/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.field;

import com.caucho.amber.field.EntityManyToOneField;
import com.caucho.amber.field.Id;
import com.caucho.amber.field.IdField;
import com.caucho.amber.field.IdentifyingKeyPropertyField;
import com.caucho.amber.field.KeyPropertyField;
import com.caucho.amber.query.AmberExpr;
import com.caucho.amber.query.KeyManyToOneExpr;
import com.caucho.amber.query.PathExpr;
import com.caucho.amber.query.QueryParser;
import com.caucho.amber.table.Column;
import com.caucho.amber.table.ForeignColumn;
import com.caucho.amber.table.LinkColumns;
import com.caucho.amber.type.EntityType;
import com.caucho.amber.type.Type;
import com.caucho.config.ConfigException;
import com.caucho.java.JavaWriter;
import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyManyToOneField
extends EntityManyToOneField
implements IdField {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/amber/field/KeyManyToOneField"));
    protected static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/amber/field/KeyManyToOneField"));
    private ArrayList<KeyPropertyField> _idFields = new ArrayList();
    private boolean _isKeyField;

    public KeyManyToOneField(EntityType entityType, String name) throws ConfigException {
        super(entityType, name);
    }

    public KeyManyToOneField(EntityType entityType, String name, LinkColumns columns) throws ConfigException {
        super(entityType, name);
        this.setLinkColumns(columns);
        this.setSourceCascadeDelete(true);
    }

    @Override
    public String getGenerator() {
        return null;
    }

    @Override
    public Type getType() {
        return this.getEntityType();
    }

    public Column getColumn() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setKeyField(boolean isKeyField) {
        this._isKeyField = isKeyField;
    }

    @Override
    public String getForeignTypeName() {
        return this.getJavaTypeName();
    }

    @Override
    public boolean isTargetCascadeDelete() {
        return false;
    }

    @Override
    public boolean isSourceCascadeDelete() {
        return true;
    }

    @Override
    public void init() throws ConfigException {
        super.init();
        ArrayList<IdField> keys = this.getEntityType().getId().getKeys();
        ArrayList<ForeignColumn> columns = this.getLinkColumns().getColumns();
        for (int i = 0; i < keys.size(); ++i) {
            IdField key = keys.get(i);
            ForeignColumn column = columns.get(i);
            IdentifyingKeyPropertyField field = new IdentifyingKeyPropertyField(this.getSourceType(), column);
            this._idFields.add(field);
        }
    }

    @Override
    public int getComponentCount() {
        return this.getEntityType().getId().getKeyCount();
    }

    @Override
    public ArrayList<Column> getColumns() {
        ArrayList<Column> columns = new ArrayList<Column>();
        columns.addAll(this.getLinkColumns().getColumns());
        return columns;
    }

    public KeyPropertyField getIdField(IdField field) {
        ArrayList<IdField> keys = this.getEntityType().getId().getKeys();
        if (this._idFields.size() != keys.size()) {
            try {
                this.init();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        for (int i = 0; i < keys.size(); ++i) {
            if (keys.get(i) != field) continue;
            return this._idFields.get(i);
        }
        throw new IllegalStateException(field.toString());
    }

    @Override
    public AmberExpr createExpr(QueryParser parser, PathExpr parent) {
        return new KeyManyToOneExpr(parent, this);
    }

    @Override
    public String generateMatchArgWhere(String id) {
        return this.getLinkColumns().generateMatchArgSQL(id);
    }

    @Override
    public String generateRawWhere(String id) {
        CharBuffer cb = new CharBuffer();
        String prefix = new StringBuffer().append(id).append(".").append(this.getName()).toString();
        ArrayList<IdField> keys = this.getEntityType().getId().getKeys();
        for (int i = 0; i < keys.size(); ++i) {
            if (i != 0) {
                cb.append(" AND ");
            }
            cb.append(keys.get(i).generateRawWhere(prefix));
        }
        return cb.toString();
    }

    @Override
    public String generateGetProxyProperty(String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void generateJoin(CharBuffer cb, String table1, String table2) {
        cb.append(this.getLinkColumns().generateJoin(table1, table2));
    }

    @Override
    public ForeignColumn getColumn(Column key) {
        return this.getLinkColumns().getSourceColumn(key);
    }

    @Override
    public int generateLoadForeign(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        return this.generateLoadForeign(out, rs, indexVar, index, this.getForeignTypeName().replace('.', '_'));
    }

    @Override
    public String generateSuperGetter() {
        if (this.isAbstract() || this.getGetterMethod() == null) {
            return this.getFieldName();
        }
        return new StringBuffer().append(this.getGetterMethod().getName()).append("()").toString();
    }

    @Override
    public String generateSuperSetter(String value) {
        if (this.isAbstract() || this.getGetterMethod() == null || this.getSetterMethod() == null) {
            return new StringBuffer().append(this.getFieldName()).append(" = ").append(value).append(";").toString();
        }
        return new StringBuffer().append(this.getSetterMethod().getName()).append("(").append(value).append(")").toString();
    }

    @Override
    public int generateLoadForeign(JavaWriter out, String rs, String indexVar, int index, String name) throws IOException {
        out.print(new StringBuffer().append("(").append(this.getForeignTypeName()).append(") ").toString());
        out.print(new StringBuffer().append("aConn.loadProxy(\"").append(this.getEntityType().getName()).append("\", ").toString());
        index = this.getEntityType().getId().generateLoadForeign(out, rs, indexVar, index, this.getName());
        out.println(");");
        return index;
    }

    @Override
    public void generatePrologue(JavaWriter out, HashSet<Object> completedSet) throws IOException {
        super.generatePrologue(out, completedSet);
        if (this.isAbstract()) {
            out.println();
            out.println();
            out.println(new StringBuffer().append("public ").append(this.getJavaTypeName()).append(" ").append(this.getGetterName()).append("()").toString());
            out.println("{");
            out.println(new StringBuffer().append("  return ").append(this.getFieldName()).append(";").toString());
            out.println("}");
            out.println();
            out.println(new StringBuffer().append("public void ").append(this.getSetterName()).append("(").append(this.getJavaTypeName()).append(" v)").toString());
            out.println("{");
            out.println(new StringBuffer().append("  ").append(this.getFieldName()).append(" = v;").toString());
            out.println("}");
        }
    }

    @Override
    public void generateSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        ArrayList<ForeignColumn> columns = this.getLinkColumns().getColumns();
        Id id = this.getEntityType().getId();
        ArrayList<IdField> keys = id.getKeys();
        String prop = value != null ? this.generateGet(value) : null;
        for (int i = 0; i < columns.size(); ++i) {
            IdField key = keys.get(i);
            ForeignColumn column = columns.get(i);
            column.generateSet(out, pstmt, index, key.generateGet(prop));
        }
    }

    @Override
    public void generateSet(JavaWriter out, String pstmt, String index) throws IOException {
        String var = this.getFieldName();
        Id id = this.getEntityType().getId();
        ArrayList<IdField> keys = id.getKeys();
        for (int i = 0; i < keys.size(); ++i) {
            IdField key = keys.get(i);
            key.getType().generateSet(out, pstmt, index, key.generateGet(var));
        }
    }

    @Override
    public void generateSetInsert(JavaWriter out, String pstmt, String index) throws IOException {
        String value = this.generateSuperGetter();
        out.println(new StringBuffer().append("if (").append(this.getEntityType().generateIsNull(value)).append(") {").toString());
        out.pushDepth();
        this.getEntityType().generateSetNull(out, pstmt, index);
        out.popDepth();
        out.println("} else {");
        out.pushDepth();
        this.generateSet(out, pstmt, index);
        out.popDepth();
        out.println("}");
    }

    @Override
    public String generateSetKeyProperty(String key, String value) throws IOException {
        if (this._isKeyField) {
            return new StringBuffer().append(key).append(".").append(this.getName()).append(" = ").append(value).toString();
        }
        return this.generateSet(key, value);
    }

    @Override
    public String generateGetKeyProperty(String key) throws IOException {
        if (this._isKeyField) {
            return new StringBuffer().append(key).append(".").append(this.getName()).toString();
        }
        return this.generateGet(key);
    }

    @Override
    public void generateSetGeneratedKeys(JavaWriter out, String pstmt) throws IOException {
    }

    @Override
    public void generateCheckCreateKey(JavaWriter out) throws IOException {
        out.println(new StringBuffer().append("if (").append(this.generateSuperGetter()).append(" == null)").toString());
        out.println(new StringBuffer().append("  throw new com.caucho.amber.AmberException(\"primary key must not be null on creation.  ").append(this.getGetterName()).append("() must not return null.\");").toString());
    }

    @Override
    public String generateIsNull(String value) {
        return new StringBuffer().append("(").append(value).append(" == null)").toString();
    }

    @Override
    public String toValue(String value) {
        return new StringBuffer().append("((").append(this.getJavaTypeName()).append(") ").append(value).append(")").toString();
    }
}

