/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.field;

import com.caucho.amber.field.AbstractField;
import com.caucho.amber.field.IdField;
import com.caucho.amber.table.Column;
import com.caucho.amber.type.EntityType;
import com.caucho.config.ConfigException;
import com.caucho.java.JavaWriter;
import com.caucho.log.Log;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityMapField
extends AbstractField {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/amber/field/EntityMapField"));
    protected static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/amber/field/EntityMapField"));
    private ArrayList<Column> _indexColumns;
    private Method _mapMethod;
    private EntityType _targetType;
    private IdField _id;
    private IdField _index;

    public EntityMapField(EntityType entityType) {
        super(entityType);
    }

    @Override
    public void setName(String name) {
        try {
            super.setName(name);
        }
        catch (ConfigException e) {
            log.log(Level.FINEST, e.toString(), e);
        }
        this.setJavaType(ClassLiteral.getClass((String)"java/util/Map"));
    }

    public void setTargetType(EntityType type) {
        this._targetType = type;
    }

    @Override
    public boolean isUpdateable() {
        return false;
    }

    public void setMapMethod(Method method) {
        this._mapMethod = method;
    }

    public void setId(IdField id) {
        this._id = id;
    }

    public void setIndex(IdField index) {
        this._index = index;
    }

    public void setIndexColumns(ArrayList<Column> columns) {
        this._indexColumns = columns;
    }

    public ArrayList<Column> getIndexColumns() {
        return this._indexColumns;
    }

    @Override
    public void generateUpdate(JavaWriter out, String mask, String pstmt, String index) throws IOException {
    }

    @Override
    public void generateLoadFromObject(JavaWriter out, String obj) throws IOException {
    }

    @Override
    public void generateUpdateFromObject(JavaWriter out, String obj) throws IOException {
    }

    public String generateLoadSelect(String id) {
        return null;
    }

    @Override
    public void generateCopyUpdateObject(JavaWriter out, String dst, String src, int updateIndex) throws IOException {
    }

    @Override
    public void generateCopyLoadObject(JavaWriter out, String dst, String src, int loadIndex) throws IOException {
    }

    @Override
    public void generateSuperGetter(JavaWriter out) throws IOException {
    }

    @Override
    public void generateSuperSetter(JavaWriter out) throws IOException {
    }

    @Override
    public void generateGetProperty(JavaWriter out) throws IOException {
        if (this.getGetterMethod() != null) {
            out.println();
            out.println(new StringBuffer().append("public ").append(this.getJavaTypeName()).append(" ").append(this.getGetterName()).append("()").toString());
            out.println("{");
            out.pushDepth();
            out.println("return null;");
            out.popDepth();
            out.println("}");
        }
        if (this._mapMethod != null) {
            IdField key;
            int i;
            out.println();
            out.print("public ");
            out.printClass(this._mapMethod.getReturnType());
            out.print(new StringBuffer().append(" ").append(this._mapMethod.getName()).append("(").toString());
            out.printClass(this._mapMethod.getParameterTypes()[0]);
            out.println(" a0)");
            out.println("{");
            out.pushDepth();
            out.println("if (__caucho_session == null)");
            out.println("  return null;");
            out.println();
            out.println("try {");
            out.pushDepth();
            out.println("com.caucho.amber.AmberQuery query;");
            EntityType targetType = this._targetType;
            String table = targetType.getName();
            out.print("String sql = \"SELECT o");
            out.print(new StringBuffer().append(" FROM ").append(table).append(" o").toString());
            out.print(" WHERE ");
            EntityType sourceType = this.getSourceType();
            ArrayList<IdField> keys = sourceType.getId().getKeys();
            out.print(new StringBuffer().append("o.").append(this._index.getName()).append("=?1").toString());
            for (i = 0; i < keys.size(); ++i) {
                key = keys.get(i);
                out.print(" AND ");
                out.print(new StringBuffer().append("o.").append(this._id.getName()).append(".").append(key.getName()).append("=?").append(i + 2).toString());
            }
            out.println("\";");
            out.println("query = __caucho_session.prepareQuery(sql);");
            out.println("int index = 1;");
            this._index.getType().generateSet(out, "query", "index", "a0");
            for (i = 0; i < keys.size(); ++i) {
                key = keys.get(i);
                key.generateSet(out, "query", "index", "this");
            }
            out.print("return (");
            out.printClass(this._mapMethod.getReturnType());
            out.println(") query.getSingleResult();");
            out.popDepth();
            out.println("} catch (Exception e) {");
            out.println("  throw com.caucho.amber.AmberRuntimeException.create(e);");
            out.println("}");
            out.popDepth();
            out.println("}");
        }
    }
}

