/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.field;

import com.caucho.amber.AmberRuntimeException;
import com.caucho.amber.field.AbstractField;
import com.caucho.amber.field.DependentEntityOneToOneField;
import com.caucho.amber.field.Id;
import com.caucho.amber.field.IdField;
import com.caucho.amber.field.PropertyField;
import com.caucho.amber.query.AmberExpr;
import com.caucho.amber.query.ManyToOneExpr;
import com.caucho.amber.query.PathExpr;
import com.caucho.amber.query.QueryParser;
import com.caucho.amber.table.Column;
import com.caucho.amber.table.ForeignColumn;
import com.caucho.amber.table.LinkColumns;
import com.caucho.amber.table.Table;
import com.caucho.amber.type.EntityType;
import com.caucho.amber.type.Type;
import com.caucho.config.ConfigException;
import com.caucho.java.JavaWriter;
import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityManyToOneField
extends AbstractField {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/amber/field/EntityManyToOneField"));
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/amber/field/EntityManyToOneField"));
    private LinkColumns _linkColumns;
    private EntityType _targetType;
    private int _targetLoadIndex;
    private DependentEntityOneToOneField _targetField;
    private PropertyField _aliasField;
    private boolean _isInsert = true;
    private boolean _isUpdate = true;
    private boolean _isSourceCascadeDelete;
    private boolean _isTargetCascadeDelete;

    public EntityManyToOneField(EntityType entityType, String name) throws ConfigException {
        super(entityType, name);
    }

    public EntityManyToOneField(EntityType entityType) {
        super(entityType);
    }

    public void setType(Type targetType) {
        if (!(targetType instanceof EntityType)) {
            throw new AmberRuntimeException(L.l("many-to-one requires an entity target at '{0}'", targetType));
        }
        this._targetType = (EntityType)targetType;
    }

    public EntityType getEntityType() {
        return this._targetType;
    }

    public String getForeignTypeName() {
        return this.getEntityType().getForeignTypeName();
    }

    public void setTargetCascadeDelete(boolean isCascadeDelete) {
        this._isTargetCascadeDelete = isCascadeDelete;
    }

    public void setSourceCascadeDelete(boolean isCascadeDelete) {
        this._isSourceCascadeDelete = isCascadeDelete;
    }

    public boolean isTargetCascadeDelete() {
        return this._isTargetCascadeDelete;
    }

    public boolean isSourceCascadeDelete() {
        return this._isSourceCascadeDelete;
    }

    public void setLinkColumns(LinkColumns linkColumns) {
        this._linkColumns = linkColumns;
    }

    public LinkColumns getLinkColumns() {
        return this._linkColumns;
    }

    public void setTargetField(DependentEntityOneToOneField field) {
        this._targetField = field;
    }

    public void setAliasField(PropertyField alias) {
        this._aliasField = alias;
    }

    @Override
    public void init() throws ConfigException {
        super.init();
        Id id = this.getEntityType().getId();
        ArrayList<Column> keys = id.getColumns();
        if (this._linkColumns == null) {
            ArrayList<ForeignColumn> columns = new ArrayList<ForeignColumn>();
            for (int i = 0; i < keys.size(); ++i) {
                Column key = keys.get(i);
                String name = keys.size() == 1 ? this.getName() : new StringBuffer().append(this.getName()).append("_").append(key.getName()).toString();
                columns.add(this.getSourceType().getTable().createForeignColumn(name, key));
            }
            this._linkColumns = new LinkColumns(this.getSourceType().getTable(), this._targetType.getTable(), columns);
        }
        if (this.getSourceType().getId() != null) {
            for (IdField field : this.getSourceType().getId().getKeys()) {
                if (!(field instanceof PropertyField)) continue;
                PropertyField prop = (PropertyField)((Object)field);
                for (ForeignColumn column : this._linkColumns.getColumns()) {
                    if (!prop.getColumn().getName().equals(column.getName())) continue;
                    this._aliasField = prop;
                }
            }
        }
        this._targetLoadIndex = this.getSourceType().nextLoadGroupIndex();
        this._linkColumns.setTargetCascadeDelete(this.isTargetCascadeDelete());
        this._linkColumns.setSourceCascadeDelete(this.isSourceCascadeDelete());
    }

    @Override
    public AmberExpr createExpr(QueryParser parser, PathExpr parent) {
        return new ManyToOneExpr(parent, this._linkColumns);
    }

    public ForeignColumn getColumn(Column targetColumn) {
        return this._linkColumns.getSourceColumn(targetColumn);
    }

    @Override
    public void generateInsertColumns(ArrayList<String> columns) {
        if (this._isInsert && this._aliasField == null) {
            this._linkColumns.generateInsert(columns);
        }
    }

    @Override
    public String generateLoadSelect(Table table, String id) {
        if (this._aliasField != null) {
            return null;
        }
        if (this._linkColumns.getSourceTable() != table) {
            return null;
        }
        return this._linkColumns.generateSelectSQL(id);
    }

    @Override
    public String generateSelect(String id) {
        if (this._aliasField != null) {
            return null;
        }
        return this._linkColumns.generateSelectSQL(id);
    }

    @Override
    public void generateUpdate(CharBuffer sql) {
        if (this._aliasField != null) {
            return;
        }
        if (this._isUpdate) {
            sql.append(this._linkColumns.generateUpdateSQL());
        }
    }

    @Override
    public void generatePrologue(JavaWriter out, HashSet<Object> completedSet) throws IOException {
        super.generatePrologue(out, completedSet);
        out.println();
        Id id = this.getEntityType().getId();
        out.println(new StringBuffer().append("private transient ").append(id.getForeignTypeName()).append(" __caucho_").append(this.getName()).append(";").toString());
        if (this._aliasField == null) {
            id.generatePrologue(out, completedSet, this.getName());
        }
    }

    public void generateJoin(CharBuffer cb, String sourceTable, String targetTable) {
        cb.append(this._linkColumns.generateJoin(sourceTable, targetTable));
    }

    @Override
    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        if (this._aliasField != null) {
            return index;
        }
        out.print(new StringBuffer().append("__caucho_").append(this.getName()).append(" = ").toString());
        index = this.getEntityType().getId().generateLoadForeign(out, rs, indexVar, index, this.getName());
        out.println(";");
        out.println(new StringBuffer().append(this.generateSuperSetter("null")).append(";").toString());
        out.println(new StringBuffer().append("__caucho_loadMask &= ~").append(1L << this._targetLoadIndex).append("L;").toString());
        return index;
    }

    @Override
    public void generateGetProperty(JavaWriter out) throws IOException {
        String javaType = this.getJavaTypeName();
        out.println();
        out.println(new StringBuffer().append("public ").append(javaType).append(" ").append(this.getGetterName()).append("()").toString());
        out.println("{");
        out.pushDepth();
        out.print("if (__caucho_session != null && ");
        out.println(new StringBuffer().append("(__caucho_loadMask & ").append(1L << this._targetLoadIndex).append("L) == 0) {").toString());
        out.pushDepth();
        if (this._aliasField == null) {
            out.println(new StringBuffer().append("__caucho_load_").append(this.getLoadGroupIndex()).append("(__caucho_session);").toString());
            out.println(new StringBuffer().append("__caucho_loadMask |= ").append(1L << this._targetLoadIndex).append("L;").toString());
            out.print(new StringBuffer().append(javaType).append(" v = (").append(javaType).append(") __caucho_session.loadProxy(\"").append(this.getEntityType().getName()).append("\", ").toString());
            out.println(new StringBuffer().append("__caucho_").append(this.getName()).append(");").toString());
            out.println(new StringBuffer().append(this.generateSuperSetter("v")).append(";").toString());
            out.println("return v;");
        } else {
            out.println(new StringBuffer().append("__caucho_loadMask |= ").append(1L << this._targetLoadIndex).append("L;").toString());
            out.print(new StringBuffer().append(javaType).append(" v = (").append(javaType).append(") __caucho_session.loadProxy(\"").append(this.getEntityType().getName()).append("\", ").toString());
            out.println(new StringBuffer().append(this._aliasField.generateGet("super")).append(");").toString());
            out.println(new StringBuffer().append(this.generateSuperSetter("v")).append(";").toString());
            out.println("return v;");
        }
        out.popDepth();
        out.println("}");
        out.println("else");
        out.println(new StringBuffer().append("  return ").append(this.generateSuperGetter()).append(";").toString());
        out.popDepth();
        out.println("}");
    }

    @Override
    public void generateCopyUpdateObject(JavaWriter out, String dst, String src, int updateIndex) throws IOException {
        if (this.getIndex() == updateIndex) {
            out.println(new StringBuffer().append(this.generateAccessor(dst)).append(" = ").append(this.generateAccessor(src)).append(";").toString());
            String value = this.generateGet(src);
            out.println(new StringBuffer().append(this.generateSet(dst, value)).append(";").toString());
        }
    }

    @Override
    public void generateCopyLoadObject(JavaWriter out, String dst, String src, int updateIndex) throws IOException {
        if (this.getLoadGroupIndex() == updateIndex) {
            out.println(new StringBuffer().append(this.generateAccessor(dst)).append(" = ").append(this.generateAccessor(src)).append(";").toString());
            String value = this.generateGet(src);
            out.println(new StringBuffer().append(this.generateSet(dst, value)).append(";").toString());
        }
    }

    private String generateAccessor(String src) {
        String var = new StringBuffer().append("__caucho_").append(this.getName()).toString();
        if (src.equals("super")) {
            return var;
        }
        return new StringBuffer().append("((").append(this.getSourceType().getInstanceClassName()).append(") ").append(src).append(").").append(var).toString();
    }

    @Override
    public void generateSetProperty(JavaWriter out) throws IOException {
        Id id = this.getEntityType().getId();
        String var = new StringBuffer().append("__caucho_").append(this.getName()).toString();
        String keyType = this.getEntityType().getId().getForeignTypeName();
        out.println();
        out.println(new StringBuffer().append("public void ").append(this.getSetterName()).append("(").append(this.getJavaTypeName()).append(" v)").toString());
        out.println("{");
        out.pushDepth();
        if (this._aliasField == null) {
            out.println(new StringBuffer().append("if ((__caucho_loadMask & ").append(1L << this.getLoadGroupIndex()).append("L) == 0 && __caucho_session != null) {").toString());
            out.println("  __caucho_load_0(__caucho_session);");
            out.println("}");
            out.println();
            out.println("if (v == null) {");
            out.println(new StringBuffer().append("  if (").append(var).append(" == null) {").toString());
            out.println(new StringBuffer().append("    ").append(this.generateSuperSetter("null")).append(";").toString());
            out.println("    return;");
            out.println("  }");
            out.println();
            out.println(new StringBuffer().append("  ").append(var).append(" = null;").toString());
            out.println("} else {");
            out.pushDepth();
            out.print(new StringBuffer().append(keyType).append(" key = ").toString());
            EntityType targetType = this.getEntityType();
            if (targetType.isEJBProxy(this.getJavaTypeName())) {
                out.print(id.generateGetProxyKey("v"));
            } else {
                String v = new StringBuffer().append("((").append(this.getEntityType().getInstanceClassName()).append(") v)").toString();
                out.print(id.toObject(id.generateGetProperty(v)));
            }
            out.println(";");
            out.println();
            out.println(new StringBuffer().append("if (key.equals(").append(var).append(")) {").toString());
            out.println(new StringBuffer().append("  ").append(this.generateSuperSetter("v")).append(";").toString());
            out.println("  return;");
            out.println("}");
            out.println();
            out.println(new StringBuffer().append(var).append(" = key;").toString());
            out.popDepth();
            out.println("}");
            out.println();
            out.println(new StringBuffer().append(this.generateSuperSetter("v")).append(";").toString());
            out.println();
            out.println("if (__caucho_session != null) {");
            out.pushDepth();
            out.println(new StringBuffer().append("__caucho_dirtyMask |= ").append(1L << this.getIndex()).append("L;").toString());
            out.println(new StringBuffer().append("__caucho_loadMask |= ").append(1L << this._targetLoadIndex).append("L;").toString());
            out.println("__caucho_session.update(this);");
            out.println(new StringBuffer().append("__caucho_session.addCompletion(__caucho_home.createManyToOneCompletion(\"").append(this.getName()).append("\", this, v));").toString());
            out.println();
            out.popDepth();
            out.println("}");
        } else {
            out.println("throw new IllegalStateException(\"aliased field cannot be set\");");
        }
        out.popDepth();
        out.println("}");
    }

    @Override
    public void generateSet(JavaWriter out, String pstmt, String index, String source) throws IOException {
        IdField key;
        if (this._aliasField != null) {
            return;
        }
        if (source == null) {
            throw new NullPointerException();
        }
        String var = new StringBuffer().append("__caucho_").append(this.getName()).toString();
        if (!source.equals("this") && !source.equals("super")) {
            var = new StringBuffer().append(source).append(".").append(var).toString();
        }
        out.println(new StringBuffer().append("if (").append(var).append(" != null) {").toString());
        out.pushDepth();
        Id id = this.getEntityType().getId();
        ArrayList<IdField> keys = id.getKeys();
        if (keys.size() == 1) {
            IdField key2 = keys.get(0);
            key2.getType().generateSet(out, pstmt, index, key2.getType().generateCastFromObject(var));
        } else {
            for (int i = 0; i < keys.size(); ++i) {
                key = keys.get(i);
                key.getType().generateSet(out, pstmt, index, key.generateGetKeyProperty(var));
            }
        }
        out.popDepth();
        out.println("} else {");
        out.pushDepth();
        for (int i = 0; i < keys.size(); ++i) {
            key = keys.get(i);
            key.getType().generateSetNull(out, pstmt, index);
        }
        out.popDepth();
        out.println("}");
    }

    @Override
    public void generateUpdateFromObject(JavaWriter out, String obj) throws IOException {
        String var = new StringBuffer().append("__caucho_").append(this.getName()).toString();
        out.println(new StringBuffer().append(var).append(" = ").append(obj).append(".").append(var).append(";").toString());
    }

    @Override
    public void generateInvalidateForeign(JavaWriter out) throws IOException {
        out.println(new StringBuffer().append("if (\"").append(this._targetType.getTable().getName()).append("\".equals(table)) {").toString());
        out.pushDepth();
        out.println("__caucho_loadMask = 0L;");
        out.popDepth();
        out.println("}");
    }

    @Override
    public void generatePreDelete(JavaWriter out) throws IOException {
        if (!this.isTargetCascadeDelete()) {
            return;
        }
        String var = new StringBuffer().append("caucho_").append(this.getName()).toString();
        out.println(new StringBuffer().append(this.getJavaTypeName()).append(" ").append(var).append(" = ").append(this.getGetterName()).append("();").toString());
    }

    @Override
    public void generatePostDelete(JavaWriter out) throws IOException {
        if (!this.isTargetCascadeDelete()) {
            return;
        }
        String var = new StringBuffer().append("caucho_").append(this.getName()).toString();
        out.println(new StringBuffer().append("if (").append(var).append(" != null) {").toString());
        out.println("  try {");
        out.println(new StringBuffer().append("    ").append(var).append(".remove();").toString());
        out.println("  } catch (Exception e) {");
        out.println("    throw com.caucho.amber.AmberRuntimeException.create(e);");
        out.println("  }");
        out.println("}");
    }
}

