/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.field;

import com.caucho.amber.field.AbstractField;
import com.caucho.amber.field.EntityManyToOneField;
import com.caucho.amber.field.Id;
import com.caucho.amber.field.IdField;
import com.caucho.amber.query.AmberExpr;
import com.caucho.amber.query.DependentEntityOneToOneExpr;
import com.caucho.amber.query.PathExpr;
import com.caucho.amber.query.QueryParser;
import com.caucho.amber.table.Column;
import com.caucho.amber.table.ForeignColumn;
import com.caucho.amber.table.LinkColumns;
import com.caucho.amber.type.EntityType;
import com.caucho.amber.type.Type;
import com.caucho.config.ConfigException;
import com.caucho.java.JavaWriter;
import com.caucho.log.Log;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependentEntityOneToOneField
extends AbstractField {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/amber/field/DependentEntityOneToOneField"));
    protected static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/amber/field/DependentEntityOneToOneField"));
    private EntityManyToOneField _targetField;
    private long _targetLoadIndex;
    private boolean _isCascadeDelete;

    public DependentEntityOneToOneField(EntityType entityType, String name) throws ConfigException {
        super(entityType, name);
    }

    public void setTargetField(EntityManyToOneField targetField) {
        this._targetField = targetField;
    }

    public EntityManyToOneField getTargetField() {
        return this._targetField;
    }

    public EntityType getEntityType() {
        return this._targetField.getSourceType();
    }

    public Type getType() {
        return this.getEntityType();
    }

    public String getForeignTypeName() {
        return this.getEntityType().getForeignTypeName();
    }

    public void setColumn(Column column) {
        throw new IllegalStateException();
    }

    public void setCascadeDelete(boolean isCascadeDelete) {
        this._isCascadeDelete = isCascadeDelete;
    }

    public boolean isCascadeDelete() {
        return this._isCascadeDelete;
    }

    @Override
    public void init() throws ConfigException {
        super.init();
        this._targetLoadIndex = this.getSourceType().nextLoadGroupIndex();
    }

    @Override
    public AmberExpr createExpr(QueryParser parser, PathExpr parent) {
        return new DependentEntityOneToOneExpr(parent, this._targetField.getLinkColumns());
    }

    public ForeignColumn getColumn(IdField targetField) {
        return null;
    }

    @Override
    public void generatePrologue(JavaWriter out, HashSet<Object> completedSet) throws IOException {
        super.generatePrologue(out, completedSet);
        out.println();
        Id id = this.getEntityType().getId();
        id.generatePrologue(out, completedSet, this.getName());
    }

    public void generateJoin(CharBuffer cb, String sourceTable, String targetTable) {
        LinkColumns linkColumns = this._targetField.getLinkColumns();
        cb.append(linkColumns.generateJoin(sourceTable, targetTable));
    }

    @Override
    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        out.println(new StringBuffer().append(this.generateSuperSetter("null")).append(";").toString());
        out.println(new StringBuffer().append("__caucho_loadMask &= ~").append(1L << (int)this._targetLoadIndex).append("L;").toString());
        return index;
    }

    @Override
    public void generateGetProperty(JavaWriter out) throws IOException {
        String javaType = this.getJavaTypeName();
        out.println();
        out.println(new StringBuffer().append("public ").append(javaType).append(" ").append(this.getGetterName()).append("()").toString());
        out.println("{");
        out.pushDepth();
        out.print("if (__caucho_session != null && ");
        out.println(new StringBuffer().append("(__caucho_loadMask & ").append(1L << (int)this._targetLoadIndex).append("L) == 0) {").toString());
        out.pushDepth();
        out.println(new StringBuffer().append("__caucho_load_").append(this.getLoadGroupIndex()).append("(__caucho_session);").toString());
        out.println(new StringBuffer().append("__caucho_loadMask |= ").append(1L << (int)this._targetLoadIndex).append("L;").toString());
        out.println(new StringBuffer().append(javaType).append(" v = null;").toString());
        out.println("try {");
        out.pushDepth();
        out.print("String sql = \"");
        out.print(new StringBuffer().append("SELECT o.").append(this.getName()).append(" FROM ").append(this.getSourceType().getName()).append(" o").append(" WHERE ").toString());
        ArrayList<IdField> sourceKeys = this.getSourceType().getId().getKeys();
        for (int i = 0; i < sourceKeys.size(); ++i) {
            if (i != 0) {
                out.print(" AND ");
            }
            IdField key = sourceKeys.get(i);
            out.print(new StringBuffer().append("o.").append(key.getName()).append("=?").toString());
        }
        out.println("\";");
        out.println("com.caucho.amber.AmberQuery query = __caucho_session.prepareQuery(sql);");
        out.println("int index = 1;");
        this.getSourceType().getId().generateSet(out, "query", "index", "super");
        out.println(new StringBuffer().append("v = (").append(javaType).append(") query.getSingleResult();").toString());
        out.popDepth();
        out.println("} catch (java.sql.SQLException e) {");
        out.println("  throw new RuntimeException(e);");
        out.println("}");
        out.println(new StringBuffer().append(this.generateSuperSetter("v")).append(";").toString());
        out.println("return v;");
        out.popDepth();
        out.println("}");
        out.println("else");
        out.println(new StringBuffer().append("  return ").append(this.generateSuperGetter()).append(";").toString());
        out.popDepth();
        out.println("}");
    }

    @Override
    public void generateCopyUpdateObject(JavaWriter out, String dst, String src, int updateIndex) throws IOException {
        if (this.getIndex() == updateIndex) {
            String value = this.generateGet(src);
            out.println(new StringBuffer().append(this.generateSet(dst, value)).append(";").toString());
        }
    }

    @Override
    public void generateCopyLoadObject(JavaWriter out, String dst, String src, int updateIndex) throws IOException {
        if (this.getLoadGroupIndex() == updateIndex) {
            String value = this.generateGet(src);
            out.println(new StringBuffer().append(this.generateSet(dst, value)).append(";").toString());
        }
    }

    @Override
    public void generateSetProperty(JavaWriter out) throws IOException {
        Id id = this.getEntityType().getId();
        String keyType = this.getEntityType().getId().getForeignTypeName();
        out.println();
        out.println(new StringBuffer().append("public void ").append(this.getSetterName()).append("(").append(this.getJavaTypeName()).append(" v)").toString());
        out.println("{");
        out.pushDepth();
        out.println(new StringBuffer().append(this.generateSuperSetter("v")).append(";").toString());
        out.println("if (__caucho_session != null) {");
        out.pushDepth();
        out.println(new StringBuffer().append("__caucho_updateMask |= ").append(1L << (int)this._targetLoadIndex).append("L;").toString());
        out.println("__caucho_session.update(this);");
        out.popDepth();
        out.println("}");
        out.popDepth();
        out.println("}");
    }

    @Override
    public void generateSet(JavaWriter out, String pstmt, String index) throws IOException {
    }

    @Override
    public void generateUpdateFromObject(JavaWriter out, String obj) throws IOException {
    }

    @Override
    public void generateInvalidateForeign(JavaWriter out) throws IOException {
        out.println(new StringBuffer().append("if (\"").append(this.getEntityType().getTable().getName()).append("\".equals(table)) {").toString());
        out.pushDepth();
        out.println("__caucho_loadMask = 0;");
        out.popDepth();
        out.println("}");
    }
}

