/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.aip.ocr;

import com.baidu.aip.client.BaseClient;
import com.baidu.aip.error.AipError;
import com.baidu.aip.http.AipRequest;
import com.baidu.aip.ocr.OcrConsts;
import com.baidu.aip.util.Base64Util;
import com.baidu.aip.util.ImageUtil;
import com.baidu.aip.util.Util;
import java.io.IOException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class AipOcr
extends BaseClient {
    public AipOcr(String appId, String aipKey, String aipToken) {
        super(appId, aipKey, aipToken);
    }

    public JSONObject idcard(String imgPath, Boolean isFront, HashMap<String, String> options) {
        try {
            byte[] imgData = Util.readFileByBytes(imgPath);
            return this.idcard(imgData, isFront, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject idcard(byte[] imgData, Boolean isFront, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        JSONObject checkRet = this.checkParam(imgData);
        if (!"0".equals(checkRet.getString("error_code"))) {
            return checkRet;
        }
        this.preOperation(request);
        String base64Content = Base64Util.encode(imgData);
        if ((long)base64Content.length() > OcrConsts.OCR_MAX_IMAGE_SIZE) {
            return AipError.IMAGE_SIZE_ERROR.toJsonResult();
        }
        request.addBody("image", base64Content);
        request.addBody("id_card_side", isFront != false ? "front" : "back");
        for (Map.Entry<String, String> entry : options.entrySet()) {
            request.addBody(entry.getKey(), entry.getValue());
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/idcard");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject bankcard(String imgPath) {
        try {
            byte[] imgData = Util.readFileByBytes(imgPath);
            return this.bankcard(imgData);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject bankcard(byte[] imgData) {
        AipRequest request = new AipRequest();
        JSONObject checkRet = this.checkParam(imgData);
        if (!"0".equals(checkRet.getString("error_code"))) {
            return checkRet;
        }
        this.preOperation(request);
        String base64Content = Base64Util.encode(imgData);
        if ((long)base64Content.length() > OcrConsts.OCR_MAX_IMAGE_SIZE) {
            return AipError.IMAGE_SIZE_ERROR.toJsonResult();
        }
        request.addBody("image", base64Content);
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/bankcard");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject general(String imgPath, HashMap<String, String> options) {
        try {
            byte[] imgData = Util.readFileByBytes(imgPath);
            return this.general(imgData, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject general(byte[] imgData, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        JSONObject checkRet = this.checkParam(imgData);
        if (!"0".equals(checkRet.getString("error_code"))) {
            return checkRet;
        }
        this.preOperation(request);
        String base64Content = Base64Util.encode(imgData);
        if ((long)base64Content.length() > OcrConsts.OCR_MAX_IMAGE_SIZE) {
            return AipError.IMAGE_SIZE_ERROR.toJsonResult();
        }
        request.addBody("image", base64Content);
        request.addBody(options);
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/general");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject generalUrl(String imgUrl, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", imgUrl);
        request.addBody(options);
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/general");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject basicGeneral(String imgPath, HashMap<String, String> options) {
        try {
            byte[] imgData = Util.readFileByBytes(imgPath);
            return this.basicGeneral(imgData, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject basicGeneral(byte[] imgData, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        JSONObject checkRet = this.checkParam(imgData);
        if (!"0".equals(checkRet.getString("error_code"))) {
            return checkRet;
        }
        this.preOperation(request);
        String base64Content = Base64Util.encode(imgData);
        if ((long)base64Content.length() > OcrConsts.OCR_MAX_IMAGE_SIZE) {
            return AipError.IMAGE_SIZE_ERROR.toJsonResult();
        }
        request.addBody("image", base64Content);
        request.addBody(options);
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/general_basic");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject basicGeneralUrl(String imgUrl, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", imgUrl);
        request.addBody(options);
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/general_basic");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject accurateGeneral(String imgPath, HashMap<String, String> options) {
        try {
            byte[] imgData = Util.readFileByBytes(imgPath);
            return this.accurateGeneral(imgData, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject accurateGeneral(byte[] imgData, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(imgData);
        request.addBody("image", base64Content);
        request.addBody(options);
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/accurate");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject basicAccurateGeneral(String imgPath, HashMap<String, String> options) {
        try {
            byte[] imgData = Util.readFileByBytes(imgPath);
            return this.basicAccurateGeneral(imgData, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject basicAccurateGeneral(byte[] imgData, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(imgData);
        request.addBody("image", base64Content);
        request.addBody(options);
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/accurate_basic");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject webImage(String imgPath, HashMap<String, String> options) {
        try {
            byte[] imgData = Util.readFileByBytes(imgPath);
            return this.webImage(imgData, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject webImage(byte[] imgData, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        JSONObject checkRet = this.checkParam(imgData);
        if (!"0".equals(checkRet.getString("error_code"))) {
            return checkRet;
        }
        this.preOperation(request);
        String base64Content = Base64Util.encode(imgData);
        if ((long)base64Content.length() > OcrConsts.OCR_MAX_IMAGE_SIZE) {
            return AipError.IMAGE_SIZE_ERROR.toJsonResult();
        }
        request.addBody("image", base64Content);
        request.addBody(options);
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/webimage");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject webImageUrl(String imgUrl, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", imgUrl);
        request.addBody(options);
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/webimage");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject enhancedGeneral(String imgPath, HashMap<String, String> options) {
        try {
            byte[] imgData = Util.readFileByBytes(imgPath);
            return this.enhancedGeneral(imgData, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject enhancedGeneral(byte[] imgData, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        JSONObject checkRet = this.checkParam(imgData);
        if (!"0".equals(checkRet.getString("error_code"))) {
            return checkRet;
        }
        this.preOperation(request);
        String base64Content = Base64Util.encode(imgData);
        if ((long)base64Content.length() > OcrConsts.OCR_MAX_IMAGE_SIZE) {
            return AipError.IMAGE_SIZE_ERROR.toJsonResult();
        }
        request.addBody("image", base64Content);
        request.addBody(options);
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/general_enhanced");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject enhancedGeneralUrl(String imgUrl, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("url", imgUrl);
        request.addBody(options);
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/general_enhanced");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject drivingLicense(String imgPath, HashMap<String, String> options) {
        try {
            byte[] imgData = Util.readFileByBytes(imgPath);
            return this.drivingLicense(imgData, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject drivingLicense(byte[] imgData, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(imgData);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/driving_license");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject vehicleLicense(String imgPath, HashMap<String, String> options) {
        try {
            byte[] imgData = Util.readFileByBytes(imgPath);
            return this.vehicleLicense(imgData, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject vehicleLicense(byte[] imgData, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(imgData);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/vehicle_license");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject plateLicense(String imgPath) {
        try {
            byte[] imgData = Util.readFileByBytes(imgPath);
            return this.plateLicense(imgData);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject plateLicense(byte[] imgData) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(imgData);
        request.addBody("image", base64Content);
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/license_plate");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject receipt(String imgPath, HashMap<String, String> options) {
        try {
            byte[] imgData = Util.readFileByBytes(imgPath);
            return this.receipt(imgData, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject receipt(byte[] imgData, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(imgData);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/receipt");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject businessLicense(String imgPath, HashMap<String, String> options) {
        try {
            byte[] imgData = Util.readFileByBytes(imgPath);
            return this.businessLicense(imgData, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject businessLicense(byte[] imgData, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(imgData);
        request.addBody("image", base64Content);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/ocr/v1/business_license");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject tableRecognitionAsync(String imgPath) {
        try {
            byte[] imgData = Util.readFileByBytes(imgPath);
            return this.tableRecognitionAsync(imgData);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject tableRecognitionAsync(byte[] imgData) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(imgData);
        request.addBody("image", base64Content);
        request.setUri("https://aip.baidubce.com/rest/2.0/solution/v1/form_ocr/request");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject getTableRecognitionJsonResult(String requestId) {
        return this.getTableResultHelper(requestId, "json");
    }

    public JSONObject getTableRecognitionExcelResult(String requestId) {
        return this.getTableResultHelper(requestId, "excel");
    }

    private JSONObject getTableResultHelper(String requestId, String resultType) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("request_id", requestId);
        request.addBody("result_type", resultType);
        request.setUri("https://aip.baidubce.com/rest/2.0/solution/v1/form_ocr/get_request_result");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject tableRecognizeToJson(String imgPath, long timeoutMiliseconds) {
        try {
            byte[] imgData = Util.readFileByBytes(imgPath);
            return this.tableRecognizeToJson(imgData, timeoutMiliseconds);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject tableRecognizeToJson(byte[] imgData, long timeoutMiliseconds) {
        return this.tableRecSyncHelper(imgData, timeoutMiliseconds, "json");
    }

    public JSONObject tableRecognizeToExcelUrl(String imgPath, long timeoutMiliseconds) {
        try {
            byte[] imgData = Util.readFileByBytes(imgPath);
            return this.tableRecognizeToExcelUrl(imgData, timeoutMiliseconds);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject tableRecognizeToExcelUrl(byte[] imgData, long timeoutMiliseconds) {
        return this.tableRecSyncHelper(imgData, timeoutMiliseconds, "excel");
    }

    private JSONObject tableRecSyncHelper(byte[] imgData, long timeout, String resultType) {
        JSONObject res = this.tableRecognitionAsync(imgData);
        if (res.has("error_code")) {
            return res;
        }
        String reqId = res.getJSONArray("result").getJSONObject(0).getString("request_id");
        long start = Calendar.getInstance().getTimeInMillis();
        long sleepInterval = 2000L;
        long now;
        while ((now = Calendar.getInstance().getTimeInMillis()) - start <= timeout) {
            JSONObject result = this.getTableResultHelper(reqId, resultType);
            if (result.has("error_code")) {
                return result;
            }
            int retCode = result.getJSONObject("result").getInt("ret_code");
            if (retCode == 3) {
                return result;
            }
            try {
                Thread.sleep(sleepInterval);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
        return AipError.ASYNC_TIMEOUT_ERROR.toJsonResult();
    }

    private JSONObject checkParam(byte[] imgData) {
        HashMap<String, Integer> imgInfo = ImageUtil.getImageInfoByBytes(imgData);
        if (imgInfo == null) {
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
        Integer width = imgInfo.get("width");
        Integer height = imgInfo.get("height");
        if (width < OcrConsts.OCR_MIN_IMAGE_SIDE_LENGTH || width > OcrConsts.OCR_MAX_IMAGE_SIDE_LENGTH || height < OcrConsts.OCR_MIN_IMAGE_SIDE_LENGTH || height > OcrConsts.OCR_MAX_IMAGE_SIDE_LENGTH) {
            return AipError.IMAGE_LENGTH_ERROR.toJsonResult();
        }
        String format = ImageUtil.getImageFormatByBytes(imgData);
        if (!OcrConsts.OCR_SUPPORT_IMAGE_FORMAT.contains(format)) {
            return AipError.UNSUPPORTED_IMAGE_FORMAT_ERROR.toJsonResult();
        }
        return AipError.SUCCESS.toJsonResult();
    }
}

