/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.aip.nlp;

import com.baidu.aip.client.BaseClient;
import com.baidu.aip.http.AipRequest;
import com.baidu.aip.http.EBodyFormat;
import com.baidu.aip.nlp.ESimnetType;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class AipNlp
extends BaseClient {
    public AipNlp(String appId, String aipKey, String aipToken) {
        super(appId, aipKey, aipToken);
    }

    public JSONObject wordseg(String query) {
        return this.wordseg(query, 1);
    }

    public JSONObject wordseg(String query, int langId) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("query", query);
        request.addBody("lang_id", langId);
        request.addHeader("Content-Encoding", "GBK");
        request.addHeader("Content-Type", "application/json");
        request.setUri("https://aip.baidubce.com/rpc/2.0/nlp/v1/wordseg");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject wordpos(String query) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("query", query);
        request.setUri("https://aip.baidubce.com/rpc/2.0/nlp/v1/wordpos");
        request.addHeader("Content-Encoding", "GBK");
        request.addHeader("Content-Type", "application/json");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject wordSimEmbedding(String word1, String word2) {
        return this.wordSimEmbedding(word1, word2, null);
    }

    public JSONObject wordSimEmbedding(String word1, String word2, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("word_1", word1);
        request.addBody("word_2", word2);
        if (options != null) {
            for (Map.Entry<String, Object> entry : options.entrySet()) {
                request.addBody(entry.getKey(), entry.getValue());
            }
        }
        request.setUri("https://aip.baidubce.com/rpc/2.0/nlp/v2/word_emb_sim");
        request.addHeader("Content-Encoding", "GBK");
        request.addHeader("Content-Type", "application/json");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject wordEmbedding(String word) {
        return this.wordEmbedding(word, null);
    }

    public JSONObject wordEmbedding(String word, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("word", word);
        if (options != null) {
            for (Map.Entry<String, Object> entry : options.entrySet()) {
                request.addBody(entry.getKey(), entry.getValue());
            }
        }
        request.setUri("https://aip.baidubce.com/rpc/2.0/nlp/v2/word_emb_vec");
        request.addHeader("Content-Encoding", "GBK");
        request.addHeader("Content-Type", "application/json");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject dnnlmCn(String text) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("text", text);
        request.setUri("https://aip.baidubce.com/rpc/2.0/nlp/v2/dnnlm_cn");
        request.addHeader("Content-Encoding", "GBK");
        request.addHeader("Content-Type", "application/json");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject simnet(String text1, String text2, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("text_1", text1);
        request.addBody("text_2", text2);
        if (options != null) {
            for (Map.Entry<String, String> entry : options.entrySet()) {
                request.addBody(entry.getKey(), entry.getValue());
            }
        }
        request.setUri("https://aip.baidubce.com/rpc/2.0/nlp/v2/simnet");
        request.addHeader("Content-Encoding", "GBK");
        request.addHeader("Content-Type", "application/json");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject commentTag(String text, ESimnetType type) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("text", text);
        request.addBody("type", type.ordinal());
        request.setUri("https://aip.baidubce.com/rpc/2.0/nlp/v2/comment_tag");
        request.addHeader("Content-Encoding", "GBK");
        request.addHeader("Content-Type", "application/json");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject lexer(String text) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("text", text);
        request.setUri("https://aip.baidubce.com/rpc/2.0/nlp/v1/lexer");
        request.addHeader("Content-Encoding", "GBK");
        request.addHeader("Content-Type", "application/json");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject sentimentClassify(String text) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("text", text);
        request.setUri("https://aip.baidubce.com/rpc/2.0/nlp/v1/sentiment_classify");
        request.addHeader("Content-Encoding", "GBK");
        request.addHeader("Content-Type", "application/json");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject depParser(String text, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("text", text);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rpc/2.0/nlp/v1/depparser");
        request.addHeader("Content-Encoding", "GBK");
        request.addHeader("Content-Type", "application/json");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }
}

