/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.aip.face;

import com.baidu.aip.client.BaseClient;
import com.baidu.aip.error.AipError;
import com.baidu.aip.face.FaceConsts;
import com.baidu.aip.http.AipRequest;
import com.baidu.aip.util.Base64Util;
import com.baidu.aip.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class AipFace
extends BaseClient {
    public AipFace(String appId, String aipKey, String aipToken) {
        super(appId, aipKey, aipToken);
    }

    public JSONObject detect(String imgPath, HashMap<String, String> options) {
        try {
            byte[] imgData = Util.readFileByBytes(imgPath);
            return this.detect(imgData, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject detect(byte[] imgData, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(imgData);
        if ((long)base64Content.length() > FaceConsts.FACE_DETECT_MAX_IMAGE_SIZE) {
            return AipError.IMAGE_SIZE_ERROR.toJsonResult();
        }
        request.addBody("image", base64Content);
        request.addBody(options);
        request.setUri("https://aip.baidubce.com/rest/2.0/face/v2/detect");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject match(List<String> imgPaths, HashMap<String, String> options) {
        try {
            byte[][] imgData = new byte[imgPaths.size()][];
            int idx = 0;
            for (String path : imgPaths) {
                imgData[idx] = Util.readFileByBytes(path);
                ++idx;
            }
            return this.match(imgData, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject match(byte[][] imgData, HashMap<String, String> options) {
        AipRequest request = new AipRequest();
        ArrayList<String> buffer = new ArrayList<String>();
        for (byte[] data : imgData) {
            String base64Str = Base64Util.encode(data);
            buffer.add(base64Str);
        }
        String imgDataAll = Util.mkString(buffer.iterator(), ',');
        if ((long)imgDataAll.length() > FaceConsts.FACE_MATCH_MAX_IMAGE_SIZE) {
            return AipError.IMAGE_SIZE_ERROR.toJsonResult();
        }
        this.preOperation(request);
        request.addBody("images", imgDataAll);
        if (options != null) {
            for (Map.Entry<String, String> entry : options.entrySet()) {
                request.addBody(entry.getKey(), entry.getValue());
            }
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/face/v2/match");
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject addUser(String uid, String userInfo, List<String> groupId, String imgPath, HashMap<String, String> options) {
        try {
            byte[] imgData = Util.readFileByBytes(imgPath);
            return this.addUser(uid, userInfo, groupId, imgData, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject addUser(String uid, String userInfo, List<String> groupId, byte[] imgData, HashMap<String, String> options) {
        AipError checkGid = this.checkGroupId(groupId);
        if (!checkGid.equals((Object)AipError.SUCCESS)) {
            return checkGid.toJsonResult();
        }
        AipRequest request = new AipRequest();
        String base64Str = Base64Util.encode(imgData);
        this.preOperation(request);
        request.addBody("uid", uid);
        request.addBody("user_info", userInfo);
        request.addBody("group_id", Util.mkString(groupId.iterator(), ','));
        request.addBody("image", base64Str);
        if (options != null) {
            for (Map.Entry<String, String> entry : options.entrySet()) {
                request.addBody(entry.getKey(), entry.getValue());
            }
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/face/v2/faceset/user/add");
        AipError checkRet = this.checkSearchParams(request.getBody());
        if (!checkRet.equals((Object)AipError.SUCCESS)) {
            return checkRet.toJsonResult();
        }
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject updateUser(String uid, String userInfo, String groupId, String imgPath, HashMap<String, String> options) {
        try {
            byte[] imgData = Util.readFileByBytes(imgPath);
            return this.updateUser(uid, userInfo, groupId, imgData, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject updateUser(String uid, String userInfo, String groupId, byte[] imgData, HashMap<String, String> options) {
        AipError ret = this.checkSingleGroupId(groupId);
        if (ret != AipError.SUCCESS) {
            return ret.toJsonResult();
        }
        AipRequest request = new AipRequest();
        String base64Str = Base64Util.encode(imgData);
        this.preOperation(request);
        request.addBody("uid", uid);
        request.addBody("image", base64Str);
        request.addBody("group_id", groupId);
        request.addBody("user_info", userInfo);
        if (options != null) {
            for (Map.Entry<String, String> entry : options.entrySet()) {
                request.addBody(entry.getKey(), entry.getValue());
            }
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/face/v2/faceset/user/update");
        AipError checkRet = this.checkSearchParams(request.getBody());
        if (!checkRet.equals((Object)AipError.SUCCESS)) {
            return checkRet.toJsonResult();
        }
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject deleteUser(String uid) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("uid", uid);
        request.setUri("https://aip.baidubce.com/rest/2.0/face/v2/faceset/user/delete");
        AipError checkRet = this.checkSearchParams(request.getBody());
        if (!checkRet.equals((Object)AipError.SUCCESS)) {
            return checkRet.toJsonResult();
        }
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject deleteUser(String uid, List<String> groupId) {
        AipError ret = this.checkGroupId(groupId);
        if (ret != AipError.SUCCESS) {
            return ret.toJsonResult();
        }
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("uid", uid);
        request.addBody("group_id", Util.mkString(groupId.iterator(), ','));
        request.setUri("https://aip.baidubce.com/rest/2.0/face/v2/faceset/user/delete");
        AipError checkRet = this.checkSearchParams(request.getBody());
        if (!checkRet.equals((Object)AipError.SUCCESS)) {
            return checkRet.toJsonResult();
        }
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject verifyUser(String uid, List<String> groupId, String imgPath, HashMap<String, Object> options) {
        try {
            byte[] imgData = Util.readFileByBytes(imgPath);
            return this.verifyUser(uid, groupId, imgData, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject verifyUser(String uid, List<String> groupId, byte[] imgData, HashMap<String, Object> options) {
        AipError checkGid = this.checkGroupId(groupId);
        if (!checkGid.equals((Object)AipError.SUCCESS)) {
            return checkGid.toJsonResult();
        }
        AipRequest request = new AipRequest();
        String base64Str = Base64Util.encode(imgData);
        this.preOperation(request);
        request.addBody("uid", uid);
        request.addBody("image", base64Str);
        request.addBody("group_id", Util.mkString(groupId.iterator(), ','));
        if (options != null) {
            for (Map.Entry<String, Object> entry : options.entrySet()) {
                request.addBody(entry.getKey(), entry.getValue());
            }
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/face/v2/verify");
        AipError checkRet = this.checkSearchParams(request.getBody());
        if (!checkRet.equals((Object)AipError.SUCCESS)) {
            return checkRet.toJsonResult();
        }
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject identifyUser(List<String> groupId, String imgPath, HashMap<String, Object> options) {
        try {
            byte[] imgData = Util.readFileByBytes(imgPath);
            return this.identifyUser(groupId, imgData, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject identifyUser(List<String> groupId, byte[] imgData, HashMap<String, Object> options) {
        AipError checkGid = this.checkGroupId(groupId);
        if (!checkGid.equals((Object)AipError.SUCCESS)) {
            return checkGid.toJsonResult();
        }
        AipRequest request = new AipRequest();
        String base64Str = Base64Util.encode(imgData);
        this.preOperation(request);
        request.addBody("group_id", Util.mkString(groupId.iterator(), ','));
        request.addBody("image", base64Str);
        if (options != null) {
            for (Map.Entry<String, Object> entry : options.entrySet()) {
                request.addBody(entry.getKey(), entry.getValue());
            }
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/face/v2/identify");
        AipError checkRet = this.checkSearchParams(request.getBody());
        if (!checkRet.equals((Object)AipError.SUCCESS)) {
            return checkRet.toJsonResult();
        }
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject getUser(String uid) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("uid", uid);
        request.setUri("https://aip.baidubce.com/rest/2.0/face/v2/faceset/user/get");
        AipError checkRet = this.checkSearchParams(request.getBody());
        if (!checkRet.equals((Object)AipError.SUCCESS)) {
            return checkRet.toJsonResult();
        }
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject getUser(String uid, List<String> groupId) {
        AipError ret = this.checkGroupId(groupId);
        if (ret != AipError.SUCCESS) {
            return ret.toJsonResult();
        }
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("uid", uid);
        request.addBody("group_id", Util.mkString(groupId.iterator(), ','));
        request.setUri("https://aip.baidubce.com/rest/2.0/face/v2/faceset/user/get");
        AipError checkRet = this.checkSearchParams(request.getBody());
        if (!checkRet.equals((Object)AipError.SUCCESS)) {
            return checkRet.toJsonResult();
        }
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject getGroupList(HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        for (Map.Entry<String, Object> entry : options.entrySet()) {
            request.addBody(entry.getKey(), entry.getValue());
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/face/v2/faceset/group/getlist");
        AipError checkRet = this.checkSearchParams(request.getBody());
        if (!checkRet.equals((Object)AipError.SUCCESS)) {
            return checkRet.toJsonResult();
        }
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject getGroupUsers(String groupId, HashMap<String, Object> options) {
        AipError checkGid = this.checkSingleGroupId(groupId);
        if (!checkGid.equals((Object)AipError.SUCCESS)) {
            return checkGid.toJsonResult();
        }
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("group_id", groupId);
        for (Map.Entry<String, Object> entry : options.entrySet()) {
            request.addBody(entry.getKey(), entry.getValue());
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/face/v2/faceset/group/getusers");
        AipError checkRet = this.checkSearchParams(request.getBody());
        if (!checkRet.equals((Object)AipError.SUCCESS)) {
            return checkRet.toJsonResult();
        }
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject addGroupUser(String srcGroupId, List<String> dstGroupId, String uid) {
        AipError checkGid = this.checkSingleGroupId(srcGroupId);
        if (!checkGid.equals((Object)AipError.SUCCESS)) {
            return checkGid.toJsonResult();
        }
        checkGid = this.checkGroupId(dstGroupId);
        if (!checkGid.equals((Object)AipError.SUCCESS)) {
            return checkGid.toJsonResult();
        }
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("group_id", Util.mkString(dstGroupId.iterator(), ','));
        request.addBody("uid", uid);
        request.addBody("src_group_id", srcGroupId);
        request.setUri("https://aip.baidubce.com/rest/2.0/face/v2/faceset/group/adduser");
        AipError checkRet = this.checkSearchParams(request.getBody());
        if (!checkRet.equals((Object)AipError.SUCCESS)) {
            return checkRet.toJsonResult();
        }
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject deleteGroupUser(List<String> groupId, String uid) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        request.addBody("group_id", Util.mkString(groupId.iterator(), ','));
        request.addBody("uid", uid);
        request.setUri("https://aip.baidubce.com/rest/2.0/face/v2/faceset/group/deleteuser");
        AipError checkRet = this.checkSearchParams(request.getBody());
        if (!checkRet.equals((Object)AipError.SUCCESS)) {
            return checkRet.toJsonResult();
        }
        this.postOperation(request);
        return this.requestServer(request);
    }

    public JSONObject livenessVerify(String imgPath, HashMap<String, Object> options) {
        try {
            byte[] imgData = Util.readFileByBytes(imgPath);
            return this.livenessVerify(imgData, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject livenessVerify(byte[] imgData, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Str = Base64Util.encode(imgData);
        request.addBody("image", base64Str);
        if (options != null) {
            request.addBody(options);
        }
        request.setUri("https://aip.baidubce.com/rest/2.0/face/v2/faceverify");
        this.postOperation(request);
        return this.requestServer(request);
    }

    private AipError checkSearchParams(HashMap<String, Object> body) {
        int size;
        int imgSize;
        if (body.containsKey("image") && (long)(imgSize = ((String)body.get("image")).length()) > FaceConsts.FACE_SEARCH_MAX_IMAGE_SIZE) {
            return AipError.IMAGE_SIZE_ERROR;
        }
        if (body.containsKey("uid")) {
            String uid = (String)body.get("uid");
            if (uid.length() > FaceConsts.FACE_SEARCH_MAX_UID_SIZE) {
                return AipError.UID_SIZE_ERROR;
            }
            if (!Util.isLiteral(uid)) {
                return AipError.UID_FORMAT_ERROR;
            }
        }
        if (body.containsKey("user_info") && (size = ((String)body.get("user_info")).length()) > FaceConsts.FACE_SEARCH_MAX_USER_INFO_SIZE) {
            return AipError.USER_INFO_SIZE_ERROR;
        }
        if (body.containsKey("group_id")) {
            String groupId = (String)body.get("group_id");
            for (String gid : groupId.split(",")) {
                if (gid.length() > FaceConsts.FACE_SEARCH_MAX_GROUP_ID_SIZE) {
                    return AipError.GROUP_ID_SIZE_ERROR;
                }
                if (Util.isLiteral(gid)) continue;
                return AipError.GROUP_ID_FORMAT_ERROR;
            }
        }
        return AipError.SUCCESS;
    }

    private AipError checkGroupId(List<String> groupId) {
        for (String gid : groupId) {
            AipError ret = this.checkSingleGroupId(gid);
            if (ret == AipError.SUCCESS) continue;
            return ret;
        }
        return AipError.SUCCESS;
    }

    private AipError checkSingleGroupId(String groupId) {
        if (groupId.length() > FaceConsts.FACE_SEARCH_MAX_GROUP_ID_SIZE) {
            return AipError.GROUP_ID_SIZE_ERROR;
        }
        if (!Util.isLiteral(groupId)) {
            return AipError.GROUP_ID_FORMAT_ERROR;
        }
        return AipError.SUCCESS;
    }
}

