/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.aip.custom;

import com.baidu.aip.client.BaseClient;
import com.baidu.aip.error.AipError;
import com.baidu.aip.http.AipRequest;
import com.baidu.aip.http.EBodyFormat;
import com.baidu.aip.util.Base64Util;
import com.baidu.aip.util.Util;
import java.io.IOException;
import java.util.HashMap;
import org.json.JSONObject;

public class AipCustom
extends BaseClient {
    public AipCustom(String appId, String apiKey, String secretKey) {
        super(appId, apiKey, secretKey);
    }

    public JSONObject custom(String imgPath, HashMap<String, Object> options) {
        try {
            byte[] imgData = Util.readFileByBytes(imgPath);
            return this.custom(imgData, options);
        }
        catch (IOException e) {
            e.printStackTrace();
            return AipError.IMAGE_READ_ERROR.toJsonResult();
        }
    }

    public JSONObject custom(byte[] imgData, HashMap<String, Object> options) {
        AipRequest request = new AipRequest();
        this.preOperation(request);
        String base64Content = Base64Util.encode(imgData);
        request.addBody("image", base64Content);
        request.addBody(options);
        request.setUri("https://aip.baidubce.com/rpc/2.0/ai_custom/v1/classification/model_256");
        request.addHeader("Content-Type", "application/json");
        request.setBodyFormat(EBodyFormat.RAW_JSON);
        this.postOperation(request);
        return this.requestServer(request);
    }
}

