/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.circuitbreaker.sentinel;

import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRule;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.cloud.client.circuitbreaker.ConfigBuilder;
import org.springframework.util.Assert;

public class SentinelConfigBuilder
implements ConfigBuilder<SentinelCircuitBreakerConfiguration> {
    private String resourceName;
    private EntryType entryType;
    private List<DegradeRule> rules;

    public SentinelConfigBuilder() {
    }

    public SentinelConfigBuilder(String resourceName) {
        this.resourceName = resourceName;
    }

    public SentinelConfigBuilder resourceName(String resourceName) {
        this.resourceName = resourceName;
        return this;
    }

    public SentinelConfigBuilder entryType(EntryType entryType) {
        this.entryType = entryType;
        return this;
    }

    public SentinelConfigBuilder rules(List<DegradeRule> rules) {
        this.rules = rules;
        return this;
    }

    public SentinelCircuitBreakerConfiguration build() {
        Assert.hasText((String)this.resourceName, (String)"resourceName cannot be empty");
        List rules = Optional.ofNullable(this.rules).orElse(new ArrayList());
        EntryType entryType = Optional.ofNullable(this.entryType).orElse(EntryType.OUT);
        return new SentinelCircuitBreakerConfiguration().setResourceName(this.resourceName).setEntryType(entryType).setRules(rules);
    }

    public static class SentinelCircuitBreakerConfiguration {
        private String resourceName;
        private EntryType entryType;
        private List<DegradeRule> rules;

        public String getResourceName() {
            return this.resourceName;
        }

        public SentinelCircuitBreakerConfiguration setResourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public EntryType getEntryType() {
            return this.entryType;
        }

        public SentinelCircuitBreakerConfiguration setEntryType(EntryType entryType) {
            this.entryType = entryType;
            return this;
        }

        public List<DegradeRule> getRules() {
            return this.rules;
        }

        public SentinelCircuitBreakerConfiguration setRules(List<DegradeRule> rules) {
            this.rules = rules;
            return this;
        }
    }
}

