/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.poi.excel.sax;

import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.poi.excel.sax.ExcelSaxReader;
import cn.hutool.poi.excel.sax.ExcelSaxUtil;
import cn.hutool.poi.excel.sax.SheetDataSaxHandler;
import cn.hutool.poi.excel.sax.SheetRidReader;
import cn.hutool.poi.excel.sax.handler.RowHandler;
import cn.hutool.poi.exceptions.POIException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.xssf.eventusermodel.XSSFReader;

public class Excel07SaxReader
implements ExcelSaxReader<Excel07SaxReader> {
    private final SheetDataSaxHandler handler;

    public Excel07SaxReader(RowHandler rowHandler) {
        this.handler = new SheetDataSaxHandler(rowHandler);
    }

    public Excel07SaxReader setRowHandler(RowHandler rowHandler) {
        this.handler.setRowHandler(rowHandler);
        return this;
    }

    @Override
    public Excel07SaxReader read(File file, int rid) throws POIException {
        return this.read(file, "rId" + rid);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Excel07SaxReader read(File file, String idOrRidOrSheetName) throws POIException {
        try (OPCPackage open = OPCPackage.open((File)file, (PackageAccess)PackageAccess.READ);){
            Excel07SaxReader excel07SaxReader = this.read(open, idOrRidOrSheetName);
            return excel07SaxReader;
        }
        catch (IOException | InvalidFormatException e) {
            throw new POIException(e);
        }
    }

    @Override
    public Excel07SaxReader read(InputStream in, int rid) throws POIException {
        return this.read(in, "rId" + rid);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Excel07SaxReader read(InputStream in, String idOrRidOrSheetName) throws POIException {
        try (OPCPackage opcPackage = OPCPackage.open((InputStream)in);){
            Excel07SaxReader excel07SaxReader = this.read(opcPackage, idOrRidOrSheetName);
            return excel07SaxReader;
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
        catch (InvalidFormatException e) {
            throw new POIException(e);
        }
    }

    public Excel07SaxReader read(OPCPackage opcPackage, int rid) throws POIException {
        return this.read(opcPackage, "rId" + rid);
    }

    public Excel07SaxReader read(OPCPackage opcPackage, String idOrRidOrSheetName) throws POIException {
        try {
            return this.read(new XSSFReader(opcPackage), idOrRidOrSheetName);
        }
        catch (OpenXML4JException e) {
            throw new POIException(e);
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
    }

    public Excel07SaxReader read(XSSFReader xssfReader, String idOrRidOrSheetName) throws POIException {
        try {
            this.handler.stylesTable = xssfReader.getStylesTable();
        }
        catch (IOException | InvalidFormatException throwable) {
            // empty catch block
        }
        try {
            this.handler.sharedStringsTable = xssfReader.getSharedStringsTable();
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
        catch (InvalidFormatException e) {
            throw new POIException(e);
        }
        return this.readSheets(xssfReader, idOrRidOrSheetName);
    }

    private Excel07SaxReader readSheets(XSSFReader xssfReader, String idOrRidOrSheetName) throws POIException {
        this.handler.sheetIndex = this.getSheetIndex(xssfReader, idOrRidOrSheetName);
        InputStream sheetInputStream = null;
        try {
            if (this.handler.sheetIndex > -1) {
                sheetInputStream = xssfReader.getSheet("rId" + (this.handler.sheetIndex + 1));
                ExcelSaxUtil.readFrom(sheetInputStream, this.handler);
                this.handler.rowHandler.doAfterAllAnalysed();
            } else {
                this.handler.sheetIndex = -1;
                Iterator sheetInputStreams = xssfReader.getSheetsData();
                while (sheetInputStreams.hasNext()) {
                    this.handler.index = 0;
                    ++this.handler.sheetIndex;
                    sheetInputStream = (InputStream)sheetInputStreams.next();
                    ExcelSaxUtil.readFrom(sheetInputStream, this.handler);
                    this.handler.rowHandler.doAfterAllAnalysed();
                }
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new POIException(e);
        }
        finally {
            IoUtil.close(sheetInputStream);
        }
        return this;
    }

    private int getSheetIndex(XSSFReader xssfReader, String idOrRidOrSheetName) {
        if (StrUtil.startWithIgnoreCase((CharSequence)idOrRidOrSheetName, (CharSequence)"rId")) {
            return Integer.parseInt(StrUtil.removePrefixIgnoreCase((CharSequence)idOrRidOrSheetName, (CharSequence)"rId"));
        }
        SheetRidReader ridReader = new SheetRidReader().read(xssfReader);
        if (StrUtil.startWithIgnoreCase((CharSequence)idOrRidOrSheetName, (CharSequence)"sheetName:")) {
            Integer rid = ridReader.getRidByNameBase0(idOrRidOrSheetName = StrUtil.removePrefixIgnoreCase((CharSequence)idOrRidOrSheetName, (CharSequence)"sheetName:"));
            if (null != rid) {
                return rid;
            }
        } else {
            Integer rid = ridReader.getRidByNameBase0(idOrRidOrSheetName);
            if (null != rid) {
                return rid;
            }
            try {
                int sheetIndex = Integer.parseInt(idOrRidOrSheetName);
                rid = ridReader.getRidBySheetIdBase0(sheetIndex);
                return (Integer)ObjectUtil.defaultIfNull((Object)rid, (Object)sheetIndex);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException("Invalid rId or id or sheetName: " + idOrRidOrSheetName);
    }
}

